/*
 *  Demo.h - Demo skeleton
 *
 *  Written by Christian Bauer in 1998. Public domain.
 */

#ifndef _DEMO_H_
#define _DEMO_H_

#include <KernelKit.h>
#include <DirectWindow.h>


// Window dimensions
const int DISPLAY_X = 320;
const int DISPLAY_Y = 240;


// Window object
class DemoWindow : public BDirectWindow {
public:
	DemoWindow();
	virtual ~DemoWindow();
	virtual bool QuitRequested(void);
	virtual void DirectConnected(direct_buffer_info *info);

private:
	static status_t thread_func(void *arg);

	void init_demo();
	bool redraw_demo(void *bits, int32 bytes_per_row, color_space pixel_format);
	void exit_demo();

	sem_id drawing_sem;
	thread_id drawing_thread;

	void *bits;
	int32 bytes_per_row;
	color_space pixel_format;
	bool unclipped;
};


// Mathematical functions
extern float b_sqrt(float x);
extern float b_isqrt(float x);
extern float fastsqrt(float x);

#endif
